/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ChestBlock
extends AbstractChestBlock<ChestTileEntity>
implements IWaterLoggable {
    public static final DirectionProperty field_176459_a = HorizontalBlock.field_185512_D;
    public static final EnumProperty<ChestType> field_196314_b = BlockStateProperties.field_208140_ao;
    public static final BooleanProperty field_204511_c = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_196316_c = Block.func_208617_a(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196317_y = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape field_196318_z = Block.func_208617_a(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196313_A = Block.func_208617_a(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape field_196315_B = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final TileEntityMerger.ICallback<ChestTileEntity, Optional<IInventory>> field_220109_i = new TileEntityMerger.ICallback<ChestTileEntity, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> func_225539_a_(ChestTileEntity chestTileEntity, ChestTileEntity chestTileEntity2) {
            return Optional.of(new DoubleSidedInventory(chestTileEntity, chestTileEntity2));
        }

        @Override
        public Optional<IInventory> func_225538_a_(ChestTileEntity chestTileEntity) {
            return Optional.of(chestTileEntity);
        }

        @Override
        public Optional<IInventory> func_225537_b_() {
            return Optional.empty();
        }

        @Override
        public /* synthetic */ Object func_225537_b_() {
            return this.func_225537_b_();
        }
    };
    private static final TileEntityMerger.ICallback<ChestTileEntity, Optional<INamedContainerProvider>> field_220110_j = new TileEntityMerger.ICallback<ChestTileEntity, Optional<INamedContainerProvider>>(){

        @Override
        public Optional<INamedContainerProvider> func_225539_a_(final ChestTileEntity chestTileEntity, final ChestTileEntity chestTileEntity2) {
            final DoubleSidedInventory doubleSidedInventory = new DoubleSidedInventory(chestTileEntity, chestTileEntity2);
            return Optional.of(new INamedContainerProvider(){

                @Override
                @Nullable
                public Container createMenu(int n, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    if (chestTileEntity.func_213904_e(playerEntity) && chestTileEntity2.func_213904_e(playerEntity)) {
                        chestTileEntity.func_184281_d(playerInventory.field_70458_d);
                        chestTileEntity2.func_184281_d(playerInventory.field_70458_d);
                        return ChestContainer.func_216984_b(n, playerInventory, doubleSidedInventory);
                    }
                    return null;
                }

                @Override
                public ITextComponent func_145748_c_() {
                    if (chestTileEntity.func_145818_k_()) {
                        return chestTileEntity.func_145748_c_();
                    }
                    if (chestTileEntity2.func_145818_k_()) {
                        return chestTileEntity2.func_145748_c_();
                    }
                    return new TranslationTextComponent("container.chestDouble");
                }
            });
        }

        @Override
        public Optional<INamedContainerProvider> func_225538_a_(ChestTileEntity chestTileEntity) {
            return Optional.of(chestTileEntity);
        }

        @Override
        public Optional<INamedContainerProvider> func_225537_b_() {
            return Optional.empty();
        }

        @Override
        public /* synthetic */ Object func_225537_b_() {
            return this.func_225537_b_();
        }
    };

    protected ChestBlock(AbstractBlock.Properties properties, Supplier<TileEntityType<? extends ChestTileEntity>> supplier) {
        super(properties, supplier);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176459_a, Direction.NORTH)).func_206870_a(field_196314_b, ChestType.SINGLE)).func_206870_a(field_204511_c, false));
    }

    public static TileEntityMerger.Type func_226919_h_(BlockState blockState) {
        ChestType chestType = blockState.func_177229_b(field_196314_b);
        if (chestType == ChestType.SINGLE) {
            return TileEntityMerger.Type.SINGLE;
        }
        if (chestType == ChestType.RIGHT) {
            return TileEntityMerger.Type.FIRST;
        }
        return TileEntityMerger.Type.SECOND;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState3, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        BlockState blockState3;
        if (blockState3.func_177229_b(field_204511_c).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        if (blockState2.func_203425_a(this) && direction.func_176740_k().func_176722_c()) {
            ChestType chestType = blockState2.func_177229_b(field_196314_b);
            if (blockState3.func_177229_b(field_196314_b) == ChestType.SINGLE && chestType != ChestType.SINGLE && blockState3.func_177229_b(field_176459_a) == blockState2.func_177229_b(field_176459_a) && ChestBlock.func_196311_i(blockState2) == direction.func_176734_d()) {
                return (BlockState)blockState3.func_206870_a(field_196314_b, chestType.func_208081_a());
            }
        } else if (ChestBlock.func_196311_i(blockState3) == direction) {
            return (BlockState)blockState3.func_206870_a(field_196314_b, ChestType.SINGLE);
        }
        return super.func_196271_a(blockState3, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        if (blockState.func_177229_b(field_196314_b) == ChestType.SINGLE) {
            return field_196315_B;
        }
        switch (ChestBlock.func_196311_i(blockState)) {
            default: {
                return field_196316_c;
            }
            case SOUTH: {
                return field_196317_y;
            }
            case WEST: {
                return field_196318_z;
            }
            case EAST: 
        }
        return field_196313_A;
    }

    public static Direction func_196311_i(BlockState blockState) {
        Direction direction = blockState.func_177229_b(field_176459_a);
        return blockState.func_177229_b(field_196314_b) == ChestType.LEFT ? direction.func_176746_e() : direction.func_176735_f();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        ChestType chestType = ChestType.SINGLE;
        Direction \u26032 = blockItemUseContext.func_195992_f().func_176734_d();
        FluidState \u26033 = blockItemUseContext.func_195991_k().func_204610_c(blockItemUseContext.func_195995_a());
        boolean \u26034 = blockItemUseContext.func_225518_g_();
        Direction \u26035 = blockItemUseContext.func_196000_l();
        if (\u26035.func_176740_k().func_176722_c() && \u26034 && (\u2603 = this.func_196312_a(blockItemUseContext, \u26035.func_176734_d())) != null && \u2603.func_176740_k() != \u26035.func_176740_k()) {
            \u26032 = \u2603;
            ChestType chestType2 = chestType = \u26032.func_176735_f() == \u26035.func_176734_d() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chestType == ChestType.SINGLE && !\u26034) {
            if (\u26032 == this.func_196312_a(blockItemUseContext, \u26032.func_176746_e())) {
                chestType = ChestType.LEFT;
            } else if (\u26032 == this.func_196312_a(blockItemUseContext, \u26032.func_176735_f())) {
                chestType = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176459_a, \u26032)).func_206870_a(field_196314_b, chestType)).func_206870_a(field_204511_c, \u26033.func_206886_c() == Fluids.field_204546_a);
    }

    @Override
    public FluidState func_204507_t(BlockState blockState) {
        if (blockState.func_177229_b(field_204511_c).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(blockState);
    }

    @Nullable
    private Direction func_196312_a(BlockItemUseContext blockItemUseContext, Direction direction) {
        BlockState blockState = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a().func_177972_a(direction));
        return blockState.func_203425_a(this) && blockState.func_177229_b(field_196314_b) == ChestType.SINGLE ? blockState.func_177229_b(field_176459_a) : null;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof ChestTileEntity) {
            ((ChestTileEntity)\u2603).func_213903_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_203425_a(blockState2.func_177230_c())) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a(world, blockPos, (IInventory)((Object)tileEntity));
            world.func_175666_e(blockPos, this);
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider iNamedContainerProvider = this.func_220052_b(blockState, world, blockPos);
        if (iNamedContainerProvider != null) {
            playerEntity.func_213829_a(iNamedContainerProvider);
            playerEntity.func_71029_a(this.func_196310_d());
            PiglinTasks.func_234478_a_(playerEntity, true);
        }
        return ActionResultType.CONSUME;
    }

    protected Stat<ResourceLocation> func_196310_d() {
        return Stats.field_199092_j.func_199076_b(Stats.field_188063_ac);
    }

    @Nullable
    public static IInventory func_226916_a_(ChestBlock chestBlock, BlockState blockState, World world, BlockPos blockPos, boolean bl) {
        return chestBlock.func_225536_a_(blockState, world, blockPos, bl).apply(field_220109_i).orElse(null);
    }

    @Override
    public TileEntityMerger.ICallbackWrapper<? extends ChestTileEntity> func_225536_a_(BlockState blockState, World world, BlockPos blockPos2, boolean bl) {
        BiPredicate<IWorld, BlockPos> biPredicate = bl ? (iWorld, blockPos) -> false : ChestBlock::func_220108_a;
        return TileEntityMerger.func_226924_a_((TileEntityType)this.field_226859_a_.get(), ChestBlock::func_226919_h_, ChestBlock::func_196311_i, field_176459_a, blockState, world, blockPos2, biPredicate);
    }

    @Override
    @Nullable
    public INamedContainerProvider func_220052_b(BlockState blockState, World world, BlockPos blockPos) {
        return this.func_225536_a_(blockState, world, blockPos, false).apply(field_220110_j).orElse(null);
    }

    public static TileEntityMerger.ICallback<ChestTileEntity, Float2FloatFunction> func_226917_a_(final IChestLid iChestLid) {
        return new TileEntityMerger.ICallback<ChestTileEntity, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction func_225539_a_(ChestTileEntity chestTileEntity, ChestTileEntity chestTileEntity2) {
                return f -> Math.max(chestTileEntity.func_195480_a(f), chestTileEntity2.func_195480_a(f));
            }

            @Override
            public Float2FloatFunction func_225538_a_(ChestTileEntity chestTileEntity) {
                return chestTileEntity::func_195480_a;
            }

            @Override
            public Float2FloatFunction func_225537_b_() {
                return iChestLid::func_195480_a;
            }

            @Override
            public /* synthetic */ Object func_225537_b_() {
                return this.func_225537_b_();
            }
        };
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new ChestTileEntity();
    }

    public static boolean func_220108_a(IWorld iWorld, BlockPos blockPos) {
        return ChestBlock.func_176456_n(iWorld, blockPos) || ChestBlock.func_220107_b(iWorld, blockPos);
    }

    private static boolean func_176456_n(IBlockReader iBlockReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177984_a();
        return iBlockReader.func_180495_p(\u2603).func_215686_e(iBlockReader, \u2603);
    }

    private static boolean func_220107_b(IWorld iWorld, BlockPos blockPos) {
        List<CatEntity> list = iWorld.func_217357_a(CatEntity.class, new AxisAlignedBB(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 2, blockPos.func_177952_p() + 1));
        if (!list.isEmpty()) {
            for (CatEntity catEntity : list) {
                if (!catEntity.func_233684_eK_()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return Container.func_94526_b(ChestBlock.func_226916_a_(this, blockState, world, blockPos, false));
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_176459_a, rotation.func_185831_a(blockState.func_177229_b(field_176459_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_176459_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176459_a, field_196314_b, field_204511_c);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

